MODULE_NAME='DEMO UI Module' (DEV vdvDevice, DEV dvPanel)
(***********************************************************)
(***********************************************************)
(*  FILE_LAST_MODIFIED_ON: 04/04/2006  AT: 11:33:16        *)
(***********************************************************)
(* System Type : NetLinx                                   *)
(***********************************************************)
(* REV HISTORY:                                            *)
(***********************************************************)
(*
    $History: $
*)    
(***********************************************************)
(*          DEVICE NUMBER DEFINITIONS GO BELOW             *)
(***********************************************************)
DEFINE_DEVICE

(***********************************************************)
(*                LIBRARY DEFINITIONS GO BELOW             *)
(***********************************************************)
#INCLUDE 'SNAPI';

(***********************************************************)
(*               CONSTANT DEFINITIONS GO BELOW             *)
(***********************************************************)
DEFINE_CONSTANT



TL_FEEDBACK = 1;
LONG TL_TIMES[] = { 300 }

(***********************************************************)
(*              DATA TYPE DEFINITIONS GO BELOW             *)
(***********************************************************)
DEFINE_TYPE

(***********************************************************)
(*               VARIABLE DEFINITIONS GO BELOW             *)
(***********************************************************)
DEFINE_VARIABLE
VOLATILE INTEGER nSourceSelectBtns[] = {
	301,	//HDMI 1
	302,	//HDMI 2
	303,	//HDMI 3
	304,	//USB-C 1
	305,	//USB-C 2
	306,	//PC
	307,	//SDM
	308,	//DP
	309		//SMART SYSTEM
}

VOLATILE INTEGER nNavigationBtns[] = 
{
	45, //UP
	46, //DOWN
	47, //LEFT
	48, //RIGHT
	44,	//MENU
	49, //OK, ENTER
	50, //HOME
	101,//SETTINGS
	104 //RETURN
}

VOLATILE INTEGER nCurrentSource;
VOLATILE INTEGER nVolumeLevelSetIn;

VOLATILE INTEGER VIDEO_FREEZE_ON_BTN = 321;
VOLATILE INTEGER VIDEO_FREEZE_OFF_BTN = 322;
(***********************************************************)
(*               LATCHING DEFINITIONS GO BELOW             *)
(***********************************************************)
DEFINE_LATCHING

(***********************************************************)
(*       MUTUALLY EXCLUSIVE DEFINITIONS GO BELOW           *)
(***********************************************************)
DEFINE_MUTUALLY_EXCLUSIVE

(***********************************************************)
(*        SUBROUTINE/FUNCTION DEFINITIONS GO BELOW         *)
(***********************************************************)
(* EXAMPLE: DEFINE_FUNCTION <RETURN_TYPE> <NAME> (<PARAMETERS>) *)
(* EXAMPLE: DEFINE_CALL '<NAME>' (<PARAMETERS>) *)

(***********************************************************)
(*                STARTUP CODE GOES BELOW                  *)
(***********************************************************)
DEFINE_START

////////////////////////////////////////////////////////////
// Start Timeline
////////////////////////////////////////////////////////////
TIMELINE_CREATE(TL_FEEDBACK, TL_TIMES, 1, TIMELINE_ABSOLUTE, TIMELINE_REPEAT);

(***********************************************************)
(*                THE EVENTS GO BELOW                      *)
(***********************************************************)
DEFINE_EVENT

DATA_EVENT[vdvDevice]
{
	ONLINE:
	{
		SEND_COMMAND vdvDevice,"'?INPUTSELECT'";
	}
	
	COMMAND:
	{
		STACK_VAR CHAR sCmd[1024];
		STACK_VAR CHAR sHeader[255];
		STACK_VAR CHAR sValue[255];
		
		sCmd = DATA.TEXT;
		sHeader = DuetParseCmdHeader(sCmd);
		sValue = DuetParseCmdParam(sCmd);
		
		SELECT
		{
			
			ACTIVE(FIND_STRING(sHeader, "'INPUTSELECT'", 1) > 0):			
			{
				nCurrentSource = ATOI(sValue);
			}
		}
		
	}
}

BUTTON_EVENT[dvPanel, 5]
{
	PUSH:
	{
		TO[BUTTON.INPUT]
		SEND_COMMAND vdvDevice,'REINIT'
	}
}

BUTTON_EVENT[dvPanel, PWR_ON]
BUTTON_EVENT[dvPanel, PWR_OFF]
BUTTON_EVENT[dvPanel, POWER]
BUTTON_EVENT[dvPanel, VOL_UP]
BUTTON_EVENT[dvPanel, VOL_DN]
BUTTON_EVENT[dvPanel, VOL_MUTE]
BUTTON_EVENT[dvPanel, PIC_FREEZE]
{
	PUSH:
	{
		TO[BUTTON.INPUT.DEVICE, BUTTON.INPUT.CHANNEL];
		TO[vdvDevice, BUTTON.INPUT.CHANNEL];
	}
}

BUTTON_EVENT[dvPanel, VIDEO_FREEZE_ON_BTN]
{
	PUSH:
	{
		ON[vdvDevice, PIC_FREEZE_ON];
	}
}

BUTTON_EVENT[dvPanel, VIDEO_FREEZE_OFF_BTN]
{
	PUSH:
	{
		OFF[vdvDevice, PIC_FREEZE_ON];
	}
}

BUTTON_EVENT[dvPanel, nNavigationBtns]
{
	PUSH:
	{
		TO[BUTTON.INPUT.DEVICE, BUTTON.INPUT.CHANNEL];
		TO[vdvDevice, BUTTON.INPUT.CHANNEL];
	}
}

BUTTON_EVENT[dvPanel, nSourceSelectBtns]
{
	PUSH:
	{
		STACK_VAR INTEGER index;
		index = GET_LAST(nSourceSelectBtns);
	
		SWITCH (index)
		{
			case 1:
				SEND_COMMAND vdvDevice, "'INPUTSELECT-1'";
			case 2:
				SEND_COMMAND vdvDevice, "'INPUTSELECT-2'";
			case 3:
				SEND_COMMAND vdvDevice, "'INPUTSELECT-3'";
			case 4:
				SEND_COMMAND vdvDevice, "'INPUTSELECT-4'";
			case 5:
				SEND_COMMAND vdvDevice, "'INPUTSELECT-5'";
			case 6:
				SEND_COMMAND vdvDevice, "'INPUTSELECT-6'";
			case 7:
				SEND_COMMAND vdvDevice, "'INPUTSELECT-7'";
			case 8:
				SEND_COMMAND vdvDevice, "'INPUTSELECT-8'";
			case 9:
				SEND_COMMAND vdvDevice, "'INPUTSELECT-9'";
		}
	}
}

LEVEL_EVENT[dvPanel, 1]
{
	nVolumeLevelSetIn = LEVEL.VALUE;
}

BUTTON_EVENT[dvPanel, 1]
{
	RELEASE:
	{
		SEND_LEVEL vdvDevice, 1, nVolumeLevelSetIn;
	}
}

LEVEL_EVENT[vdvDevice, 1]
{
	SEND_LEVEL dvPanel, 1, LEVEL.VALUE;
}

////////////////////////////////////////////////////////////
// MODULE COMM
////////////////////////////////////////////////////////////
TIMELINE_EVENT[TL_FEEDBACK]
{
		[dvPanel, 8] = [vdvDevice, DEVICE_COMMUNICATING];
		[dvPanel, 9] = [vdvDevice, DATA_INITIALIZED];
		[dvPanel, 255] = [vdvDevice, POWER_FB];
		[dvPanel, PWR_ON] = [vdvDevice, POWER_FB];
		[dvPanel, PWR_OFF] = ![vdvDevice, POWER_FB];
		[dvPanel, VOL_MUTE] = [vdvDevice, VOL_MUTE_FB];
		[dvPanel, PIC_FREEZE] = [vdvDevice, PIC_FREEZE_FB];
		[dvPanel, VIDEO_FREEZE_ON_BTN] = [vdvDevice, PIC_FREEZE_FB];
		[dvPanel, VIDEO_FREEZE_OFF_BTN] = ![vdvDevice, PIC_FREEZE_FB];
		
		[dvPanel, 301] = nCurrentSource = 1;
		[dvPanel, 302] = nCurrentSource = 2;
		[dvPanel, 303] = nCurrentSource = 3;
		[dvPanel, 304] = nCurrentSource = 4;
		[dvPanel, 305] = nCurrentSource = 5;
		[dvPanel, 306] = nCurrentSource = 6;
		[dvPanel, 307] = nCurrentSource = 7;
		[dvPanel, 308] = nCurrentSource = 8;
		[dvPanel, 309] = nCurrentSource = 9;
}

DEFINE_PROGRAM

(*****************************************************************)
(*                       END OF PROGRAM                          *)
(*                                                               *)
(*         !!!  DO NOT PUT ANY CODE BELOW THIS COMMENT  !!!      *)
(*                                                               *)
(*****************************************************************)
